echo			macro	echo_exit,echo_error
			scope
			ei

			scrollaway 26

			put.DSP.LINE $echo_screen$				; Report to operator this program performs @echo.

; After sending packet this app waits for reply & compares packet received to packet sent.
; Program then reports if compare was equal or not.
; This is only used to test if server connected, running and responding.

			get.DCB	$serial1$,echo_error				; Get pointer for DCB *U1 (UART1).

			put.IO	($serial1$),6,$echo_string$,$echo_no_reply 	; @echo & 256 byte packet has been sent.

			put.DSP.LINE $try_echo$					; Tell operator sending @echo packet to server.
		
			put.IO	($serial1$),0,$echo_xmit_buff,$echo_no_reply	; @echo & 256 byte packet has been sent.

			put.DSP.LINE $packet_sent$				; Tell operator packet sent.

; Server echos packet we sent, receive that packet now.

			put.DSP.LINE $echo_wait$

		 	get.IO	($serial1$),0,$serial1$+4,echo_error		; Read 256 byte packet back from server.

			put.DSP.LINE $echo_rx$					; Report to operator packet received.

			put.DSP.LINE $echo_compare$				; Tell operator beginning comparing sent packet to received packet.
			CMP.bytes 0,$echo_xmit_buff,$serial1$+4,$echo_no_match	; CMP 256 byte buffers, if <> then goto echo_no_match.

; If we arrive here, both buffers match.

$echo_match		put.DSP.LINE $echo_match$				; Report to operator contents of both packets match.
			GOTO	$askforenter					; After operator presses enter, exit this program.

$echo_no_match		put.DSP.LINE $echo_no_match$				; Report to operator contents of packets DOES NOT match.
			GOTO	$askforenter					; After operator presses enter, exit this program.

$echo_no_reply		put.DSP.LINE $echo_no_reply$				; Tell operator no reply.
			pop	hl						; Discard return vector where error happened.

$askforenter		GOTO	echo_exit


; Data area.

$serial1$		device.U1.DCB	256					; Device control block for UART1.

; Strings used by network echo command.

$echo_string$		db	"@echo",LF.asc,ETX.asc
$echo_screen$		db	" Command server to echo packet back from client.",CR.asc
$try_echo$		db	" Sending packet to server.",CR.asc
$packet_sent$		db	" @echo packet sent.",CR.asc
$echo_wait$		db	" Waiting for server to echo packet.",CR.asc
$echo_rx$		db	" Reply packet received.",CR.asc
$echo_compare$		db	" Comparing packet sent to packet received.",CR.asc
$echo_match$		db	" *<PASS>* Packet sent matches packet received.",CR.asc
$echo_no_match$		db	" *<FAIL>* Packet sent does NOT match packet received.",CR.asc
$echo_no_reply$		db	" No reply from server.",CR.asc
$echo_xmit_buff db "The456789a1quick789b12brown89c123fox789d1234jumped12345overf123456theg1234567lazy2345678dogs3456789back456789k123456789l123456789m123456789n123456789o123456789p123456789q123456789r123456789s123456789t123456789u123456789v123456789w123456789x123456789y123456"

			endmac	echo