bind			macro	on_exit,on_error

			scrollaway				; Scroll screen away and leave cursor bottom left corner.

			ld	a,6
			ld	(net_volume),a			; Update flag in FDC driver.

			add	'0'				; Convert to ASCII.
			ld	($bind_who),a
			ld	($bound_x),a
			ld	(serv_vol_num),a		; Main menu server volume #.
			dsp.LINE $bind_screen$			; Tell operator this is bind program.
			dsp.LINE $bind_who$			; Report which vol to bind to server.

			put.IO	PUMP	DEVICE.serialnet,$bind_command$	; Send ping string to server @ping LF.asc.

$get_bind_byte	;	get.IO		$bind_timeout		; Get byte from UART1. On timeout or error goto no_pong.

			ld	a,'@'				; Is 1st char @ control code?
			cp	c				; Compare to C, C has char from GET_BYTE_UART1.
			JR     	NZ,$get_bind_byte		; Ignore if not control char & continue getting chars.

			UART1.get.bytes	6,$bind_buff+1,$bind_timeout ; get 5 bytes into bind_buff, if timout or error goto no_bind.

			CMP.bytes 6,$bound$,$bind_buff,$no_bind	; Compare '@bound' to pong_buffer. If <> goto no_pong.
			MVC	$bound_server,server_stat,12	; Change server to show available.
			PUMP	DEVICE.console,$bind_reply_rx$	; Report received @bound from server.

			UART1.get.bytes 0,$bind_buffer,$bind_timeout ; Place 256 bytes in buffer & vector on timeout.

			get.DCT	6				; Get address of DCT #6 in IY.
			ld	a,($jp_ins)
			ld	(IY),a				; Enable driver DCT6.

$bind_exit		ld	a,0ffh
			GOTO	on_exit

$bind_timeout		pop	hl				; Discard return address.

$no_bind		MVC	$server_not,server_stat,12	; Change server to show available.
			dsp.LINE $bind_not_rec$			; Tell operator no reply recieved.
			GOTO	$bind_exit

$jp_ins			jp	0

$bind_command$		db	"@bind",LF.asc,ETX.asc		; This is command sent to server.

$bound$			db	"@bound",LF.asc

$bind_buff		db	"@12345 "

$bind_screen$		db	" Bind volumes to network.",CR.asc,CR.asc,ETX.asc

$bind_who$		db	" Bind volume x to network.",CR.asc,ETX.asc

bind_who		equ	$-15				; Pointer to storage holding ascii of vol #.

$bound_server		db	"connected   "

$bind_not_rec$		db	CR.asc," Server did not reply or accept bind request.",CR.asc,CR.asc,ETX.asc

$bound_x		equ	$+24
$bind_reply_rx$		db	" Server replied, volume x is now bound to network server.",CR.asc,CR.asc,ETX.asc

$server_not		db	"unavailable "

$bind_buffer		ds	256

$serial1$		device.U1.DCB	256			; Device control block for UART1.

			endmac	bind



