RTC.lock	macro
		ld	a,00100000b			; Lock clock & disable interrupts.
		OUT0	(RTC_CTRL),a			; Execute.
		ENDMAC	RTC.lock

RTC.interrupt.true	macro
		ld	a,10100000b			; Enable interrupts & lock clock.
		OUT0	(RTC_CTRL),a			; Execute.
		ENDMAC	RTC.interrupt.true

RTC.unlock	macro	
		ld	a,00100001b			; Unlock & disable interrupts.
		OUT0	(RTC_CTRL),a
		endmac	RTC.unlock
				
RTC.HOUR.get	macro	destination
		in0	a,(RTC_HRS)				;
		ld	destination,a
		ENDMAC

RTC.HOUR.put	macro	source	
		ld	a,source
		out0	(RTC_HRS),a				;
		ENDMAC

RTC.MIN.get	macro	destination
		in0	a,(RTC_MIN)				;
		ld	destination,a
		ENDMAC

RTC.MIN.put	macro	source	
		ld	a,source
		out0	(RTC_MIN),a				;
		ENDMAC

RTC.SEC.get	macro	destination	
		in0	a,(RTC_SEC)				;
		ld	destination,a
		ENDMAC
				
RTC.SEC.put	macro	source	
		ld	a,source
		out0	(RTC_SEC),a				;
		ENDMAC

RTC.STAT.get	macro	destination	
		in0	a,(RTC_CTRL)
		ld	destination,a
		ENDMAC
				
RTC.STAT.put	macro	source
		ld	a,source
		out0	(RTC_CTRL),a
		endmac

RTC.CEN.get	macro	destination
		in0	a,(RTC_CEN)
		or	a
		jr	nz,$1
		ld	a,20h
$1		ld	destination,a		
		ENDMAC

RTC.CEN.put	macro	source	
		ld	a,source
		out0	(RTC_CEN),A	
		ENDMAC


RTC.YEAR.get	macro	destination
		in0	a,(RTC_YR)
		or	a
		jr	nz,$1
		ld	a,23h
$1		ld	destination,a
		ENDMAC

RTC.YEAR.put	macro	source	
		ld	a,source
		out0	(RTC_YR),A				;
		ENDMAC

RTC.DOM.get	macro	destination
		in0	a,(RTC_DOM)
		or	a
		jr	nz,$1
		ld	a,20h
$1		ld	destination,a
		ENDMAC

RTC.DOM.put	macro	source						
		ld	a,source
		out0	(RTC_DOM),A	
		endmac
				
RTC.DOW.get	macro	destination
		in0	a,(RTC_DOW)
		or	a
		jr	nz,$1
		ld	a,02h
$1		ld	destination,a
		ENDMAC

RTC.DOW.put	macro	source						
		ld	a,source
		out0	(RTC_DOW),A	
		endmac
					

RTC.MON.get	macro	destination
		in0	a,(RTC_MON)
		or	a
		jr	nz,$1
		ld	a,07h
$1		ld	destination,a
		ENDMAC

RTC.MON.put	macro	source	
		ld	a,source
		out0	(RTC_MON),A
		ENDMAC		