BRANCH		macro	where
		scope
		jr	where
		endmac	BRANCH

CMD_I    	MACRO   cmd			; COMMAND O/S WITH NO RETURN THE #0 STRING.
        	LD      HL,cmd			; GET ADDRESS OF STRING.
        	SVC     svc_cmdi
        	ENDMAC	CMD_I

CMD_R   	MACRO   cmd		        ; EXECUTE O/S COMMAND WITH RETURN.
        	LD      HL,cmd         		; GET ADDRESS OF COMMAND.
        	SVC     svc_cmdr
        	ENDMAC	CMD_R

DEBUG_START	macro
		SVC	svc_debug
		endmac	DEBUG_START

GOSUB		macro	where
		scope
		CALL	where
		endmac	GOSUB			
			
GOTO		macro	where
		scope
		jp	where
		endmac	GOTO

RETURN		macro
		scope
		ret				; Return from call.
		endmac	RETURN

SYS_ABORT	MACRO
		scope
		SVC	svc_abort
		ENDMAC	SYS_ABORT
		
SYS_EXIT	MACRO	exitcode
		scope
		ld	hl,exitcode
		SVC	svc_zexit
		ENDMAC	SYS_EXIT

LOOP		macro	location		; B=B-1. If B<>0 then goto location.
		scope
		djnz	location
		endmac	LOOP

FOR		MACRO	START,STOP,STEP
		SCOPE
		ld	bc,($1)
		ld	($4),bc
		JR	$5
$4		DW	0			; I hold count when running (+8).
$1		DW	START			; Start count from xx (+10).
$2		DW	STOP			; Stop when equal or greater than STOP (+12).
$3		DW	STEP			; Step by (+14).
$5		equ	$
		ENDMAC	FOR

NEXT		MACRO	pointer
		scope
		ld	hl,(pointer+10)		; Counter.
		ld	bc,(pointer+16)		; STEP
		add	hl,bc
		JR	C,$0			; Overflow, exceeds limit of counter, were done.
		PUSH	HL
		LD	BC,(pointer+14)		; Get limit.
		and	A			; Clear carry flag.
		SBC	HL,BC			; count-limit.
		POP	bc
		JP	z,pointer+4		; limit=counter? Go around again.
		JP	m,pointer+4		; limit>counter? Yes, go around again.
$0:		equ	$
		endmac	NEXT	
	
WHERE:		MACRO				; Return out location in memory.
		SVC		svc_where
		ENDMAC