; UART 0 macros.



reset.UART0.DTR	macro
		scope
		in0	a,(UART0_MCTL)		; Get current register status.
		and	11111110b		; Set bit 0 to 1.
		OUT0	(UART0_MCTL),A		; UART1 tell other end we are ready.
		endmac	reset.UART0.DTR
set.UART0.DTR	macro
		scope
		in0	a,(UART0_MCTL)		; Get current register status.
		or	1			; Set bit 0 to 1.
		OUT0	(UART0_MCTL),A		; UART1 tell other end we are ready.
		endmac	set.UART0.DTR

test.UART0.CTS	macro				; Test CTS signal on UART 0.
		scope
		IN0	a,(UART0_MSR)		; Get CTS status & test if CTS is ready..
		BIT	4,A			; Test if other end sets CTS true, they are ready to receive.
		endmac	test.UART0.CTS

test.UART0.DCD	macro
		scope
		IN0	a,(UART0_MSR)		; Get DCD status & test if DCD is ready..
		BIT	7,A			; Test if other end sets DCD true.
		endmac	test.UART0.DCD

test.UART0.DSR	macro
		scope
		IN0	a,(UART0_MSR)		; Get CTS status & test if CTS is ready..
		BIT	5,A			; Test if other end sets CTS true, they are ready to receive.
		endmac	test.UART0.DSR

test.UART0.RI	macro
		scope
		IN0	a,(UART0_MSR)		; Get Ring Indicator & test.
		BIT	6,A			; Test RI.
		endmac	test.UART0.RI

test.UART0.RX	macro
		scope
		IN0    	A,(UART0_LSR)		; Char waiting?
		AND	UART_DR			; 1 or TRUE if yes.
		endmac	test.UART0.RX

test.UART0.TX	macro
		scope				; Test UART 1 if xmitter buffer empty and ready.
		IN0 	A,(UART0_LSR)
		AND    	UART_THRE		; Returning a NE or <> 0 means ready, 1 means ready.
		endmac	test.UART0.TX
