mov.BYT		MACRO	source,destination,count ; Move Character, from my IBM MVS days.
		scope

; On entry, HL points to location containing bytes to move.
; DE contains pointer to destination.
; Length is maximum number of bytes to move (16 bits).

; On exit.
; BC=0
; HL = Pointer next char to move.
; DE = Points to next place in destination buffer to store a char.

		ld	hl,source
		ld	de,destination
		ld	bc,count
		LDIR

		ENDMAC	mov.BYT


mov.CHR		MACRO	source,destination,length,stop ; Move string from source to dest for length
		scope				; bytes or until stop byte is encountered.

; On entry, HL points to location containing bytes to move.
; Destination contains pointer of destination.
; Length is maximum number of bytes to move (16 bits).
; Move terminates before max number bytes if byte=stop value.

; On exit.
; BC=0 or BC= # chars not moved bc of termination character.
; HL = Pointer next char to move.
; DE = Points to next place in destination buffer to store a char.
; A = Termination char.


		ld	hl,source		; Where we are moving from.
		ld	de,destination		; Get destination in memory.
		ld	bc,length		; Get how many characters to move.
		dec	de			; Start back one byte.
$0:		ld	a,stop			; What character stops moving operation.
		cpi				; Compaere (HL) with A register. BC=BC-1
		IF_EQ_BRANCH	$1		; Did not get termination character? Keep looping until done.
		dec	hl
		inc	de
		ld	a,(hl)			; Get character.
		ld	(de),a			; Store in new destination.
		inc	hl
		jp	v,$0			; Keep looping until done (BC=0).
$1:		inc	de
$2:		endmac	mov.CHR
