cls			MACRO	
			scope
			SVC	svc_cls
			ENDMAC	cls

get.KBD.KEY		macro	on_error			; Get a key from keyboard.
			scope
			SVC	svc_key				; Go get key, wait until one available.
			IF_NZ_GOTO	on_error		; KI possibly routed?
			endmac	get.KBD.KEY

get.KBD.LINE		macro	num_char,buffer,on_BREAK	; Input a line from keyboard.
			scope
			ld	b,num_char			; max number of chars to input.
			ld	c,0				; Per programmers ref manual c=0.
			ld	hl,buffer			; Buffer size = num_char+1.
			SVC	svc_keyin			; Input line.
			IF_NZ_GOTO on_BREAK			; Vector to BREAK handler.
			endmac	get.KBD.LINE

get.KBD.SCAN		macro					; Scan keyboard & return in A. NZ=ERROR in A.
			scope
			SVC	svc_kbd				; Invoke supervisor call.
			endmac	get.KBD.SCAN

put.DSP.BUFFER		macro	buffer	on_error
			SVC	
			ld	hl,buffer			; Get the buffer address. Any valid ld hl,
$more_blk		ld	a,(hl)				; p/u a char.
			cp	ETX.asc				; Is it end of block?
			IF_EQ_BRANCH $blk_done			; No more chars ETX received.
			dsp.BYTE a
			inc	hl				; Bump to next char.
			jr	$more_blk			; Display more chars.
$blk_done		ENDMAC	put.DSP.BUFFER			; 0Dh or 04h (CR or ETX).

put.DSP.BYTE		macro	char				; Display char.
			ld	c,char				; char can be any valid ld c,
			SVC	svc_dsp				; Ask OS to display char.
			ENDMAC	put.DSP.BYTE

put.DSP.LINE		macro	buffer
			ld	hl,buffer			; Get the buffer address. Any valid ld hl,
			SVC	svc_dsply			; Ask OS to display up to 1st
			ENDMAC	put.DSP.LINE			; 0Dh or 04h (CR or ETX).

locate.CURSOR		macro	x,y
			scope
			ld	b,3				; Function 3, relocate cursor.
			ld	h,x
			ld	l,y				; Get column.
			SVC	svc_vdctl
			ENDMAC	locate.CURSOR

ring.BELL		macro	terminal,times			; Ring bell on terminal & get operator attention.
			scope
			ld	b,times
$9			push	bc
			PUT.char terminal,BELL.asc,$BELL.done
$BELL.done		pop	bc
			LOOP	$9
			endmac	ring.BELL

scrollaway		macro	num
			ld	b,num
$loop			ld	a,CR.asc
			put.DSP.BYTE A
			LOOP	$loop
			endmac	scrollaway