		TITLE      "***** TRSDOS *****"

		define     startup,space=RAM,ORG=%0000
		.ASSUME    ADL=0
 		
		include "copyright_messages.s"

; After reset, control is turned to 1st step, CPU initialization.
; This code begins in system overlay region, @ 1E00h.

		SUBTITLE "< SYSRES - operating system resident code. >"


		include	"D_library.s"
		include "DD_library.s"
                      
		include "trs80_macros.s"
		include "ez80_macros.s"
		include "trsos_macros.s"

		include "equates-global-lowcore.s"             ; Global equates defined by ZDS.
		include "equates-global-xref.s"                ; Global equates defined by ZDS.

		include "equates-eZ80.inc"                     ; General eZ80 equates needed in eZ80 family processors.

		include "equates-eZ80F91.inc"                  ; eZ80f91 specific equates.
		INCLUDE "equates-ez80f92.inc"                  ; eZ80f92 specific equates.
;		INCLUDE "equates-ez80f93.inc"                  ; eZ80f93 specific equates.

		include "equates-ASCII.s"                      ; Needed ASCII equates.

		include "equates-trs-flags.s"                  ; Pointers to TRSDOS internal flags.
		include "equates-trs-api.s"                    ; Constants needed for TRSDOS API interface.

		include "equates-versions.s"                   ; Control equates controlling version.

		include "equates-memory.s"                     ; Memory map & configuration for build.
		include "equates-keyboard.s"                   ; Driver for keyboard.
		include "equates-video.s"			; Driver for video memory.

freelow	equ	zspace.BYTEIO$-DVREND$
usedhi	equ	FFFFh-INTERRUPT.handler-0bh
		
		ORG	memory.PAGE0$				; And we begin.
trs_os
		include "page0.s"                              ; Critical machine vectors, hardware data & pointers.
		include "page1.s"                              ; SVC vector table.
		include "page2.s"                              ; Device Control Blocks & spares before stack. 0243h
		include "page3.s"                              ; Page 3-System stack/Sysinfo, stack 128 bytes low.

		ORG       zspace.STACK$                        ; Stack begins here.

		include "svc16-pause.s"                        ; Where pause will be.
		include "driver-sound.s"                       ; Driver for sound.
		include "svc96-dechex.s"                       ; DECHEX.                                            
		include "page4.s"
		include "dct.s"
		include "sysinfo.s"

		ORG       memory.PAGE5$                        ; ODVR/ASM - LS-DOS 6.2
                             
		SUBTITLE "<SYSRES - Device I/O handling ~ Log out routine - display & log>"
		newpage
		scope
		include "svc12-logot.s"
		include "svc11-loger.s"
		include "svc14-print.s"
		include "SVC13-msg.s"
		include "SVC105-cls.s"
		include "SVC106-ckbrkc.s"
		include "SVC09-keyin.s"
		include "SVC05-ctl.s"
		include "IOBGN.s"
		include "chainio.s"                             ; IO chaining,
		include "svc91-multiply16.s"                    ; MULTIPLY, .
		include "svc94-divide16.s"                      ; DIVIDE



;		ORG       06f6h
		include "svc97-hex16ascii.s"                    ; HEXDEC.
		include "driver-CLOCK.s"                        ; Hardware task stuff.
		include "display_clock.s"
                      
;		org       078dh
		include "SVC19-time.s"

		include "svc18-date.s"                          ; Return system DATE.
		include "traceroutine.s"
                       
;		ORG       07BDH                   
		include "svc99-hex16decascii.s"                 ; Hexadecimal display routine
		include "svc98-hex8ascii.s"
		include "scan-kflag.s"

		org       0817h
		include "videoRAM.s"                            ; Video RAM control code.
                       
;      		ORG       0877H
		include "svc102-banks.S"

		SUBTITLE "<Device I/O  zspace.DRIVERS$ >"
		
       		org         zspace.DRIVERS$

z$SYS		EQU       $                                     ; Pointer for zGTMOD.

		INCLUDE "driver-KIDVR.s"                        ; Keyboard driver.
		INCLUDE "driver-DODVR.s"                        ; Video driver.
		INCLUDE "driver-PRDVR.s"                        ; Printer driver.
		
DVREND$		EQU       $					; Start of low I/O driver area to 12FFh

; SYSGEN saves memory from DVREND$ to 12FFh to file CONFIG/SYS.CCC

		INCLUDE "driver-FDCDVR.s"                       ; Floppy disk driver
		include "driver-uart0.s"                        ; UART 0 driver.
		include "driver-uart1.s"                        ; UART 1 driver.
		include "driver-tod.s"                          ; Time Of Day Clock driver.

		ORG     zspace.BYTEIO$                          ; Beginning of sys0.

		INCLUDE "filposn.s"                             ; File positioning routines. -MUST BE FIRST-
		INCLUDE "SVC100-memory.s"
		INCLUDE "svc-handler.s"
		INCLUDE "iofunction.s"                                   
		INCLUDE "rst28.s"
		INCLUDE "executeoverlay.s"                      ; Execute overlay.
		INCLUDE "systemerror.s"
		include "svc77-run.s"
		include "svc76-load.s"
		INCLUDE "loader.s"                              ; Get the system loader.
		INCLUDE "interrupt_rst38.s"                     ; Interrupt 38h.
		INCLUDE "interrupt_TASKER.s"                    ; System tasker.                

		ORG     zspace.SYSBUF$                          ; O/S System buffer, 1D00h.
		
SBUFF$		BLKB    256,0					; Page disk I/O buffer.


; Begin IPL code @1E00h SYS0.
; This code runs one time @ BOOT/RESET/IPL.

		SUBTITLE	"< Beginning of SYS0/TRS-OS. >"

		ORG     zspace.OVERLAY$                         ; SYS0 w/code to initialize CPU/registers ipl-eZ80_CPU BIOS DOS Etc.
;		ORG     zspace.LIBRARY$				; LIBRARY$                      
;		org     zspace.APPLICATION$    			; TRSDOS applications start here.

		include	"IPL_Code.s"

		LD	DE,CFGFCB$				; Set up to load config.
		GOSUB	zLOAD					; Go to load config.

		GOTO	zICNFG					; Here we start initilization chain.		
		SUBTITLE	"< SYSRES HIGH memory region. >"
		
; HIGH$ memory contains video RAM, interrupt handler, reboot code etc.

		ORG     INTERRUPT.handler-0bh
		JR      $
		DW      ENDRAM$
		DB      6,"TRS-OS"
		include "interrupt_handler.s"                   ; Container for code handling interrupts.

reboot		JP.Lil    0FFF000h				; Code to boot back to host resides @FFF00.

		include "memory_video.s"                        ; Container for 1920 bytes video RAM.

; Memory >64K starting @010000h

		include "memory_slice0.s"                       ; Container for slice 0 data.
		include "memory_slice1.s"                       ; Container for slice 1 data.

		include 'equates-check.s'

		END       trs_os