		SUBTITLE	"< SYSRES Video RAM bank handling. >"
		newpage
		SCOPE
					
; Routine to enable / disable video RAM, changing stack if necessary.

ENADIS_DO_RAM	push		af
		ld		a,(pump_switch_value)	; Get value to place in switch instruction.
		ld		(pump_switch),a		; Enable pump counter and pumping.
		pop		af
		ret	

		di
		;LD 		(HLSAV),HL		;Save HL but not on stack 
		;PUSH		AF			;Save AF
		;POP		HL
;		LD		(AFSAV),HL
;		LD		HL,0C03h		;Can"t exceed X'F3FC"
;		ADD		HL,SP
		JR		NC,$?1

;		<* Switch to the system stack *>

		POP		HL			;Transfer RET address
		LD		(SPSAV),SP		;Save stack pointer
		LD		SP,STACK$-40h		;Keep room at top
		PUSH		hl			;Put RET back
$?1		LD		HL,DIS_DO_RAM		;Stack return to disable
		EX		(SP),HL			;video RAM below RET
		PUSH		HL
		LD		HL,OPREG_SV_AREA
OPREG_SV_PTR	EQU		$-2
		INC		HL			;Get next save location
		LD		A,(OPREG$)		;P/u port mask
		JR		NC,$?2			;Bypass if NC (no stack switch)
		AND		7Fh			;Strip bit 7 to use as flag
$?2		LD		(HL),A			;Save current state
		AND		0FCh			;Strip SEL1 & SEL0
		OR		82h			;Set SEL1,0 = (1,0) & NZ condx
		JR		DOOPREG			;Set new assignment.

		org		0846h			;maintain lowcore
DIS_DO_RAM	ret	;DI					;Routine to disable video RAM
		LD		(HLSAV),HL		;Can"t while we test stack
		PUSH		AF	
		POP		HL			;Save AF
		LD		(AFSAV),HL
		LD		HL,(OPREG_SV_PTR)
		LD		A,(HL)			;P/u previous state
		BIT		7,A			;Test if we switch stack
		SET		7,A			;Make sure PAGE is set
		DEC		HL
DOOPREG		LD		(OPREG_SV_PTR),HL
		LD		(OPREG$),A		;Restore port image.
		;OUT		(zOPREG),a
		nop					; Memory holder for out.
		nop					; Memory holder for out.
		JR		NZ,$?3

;	Switch back to the old stack

		LD		SP,$-$			;Get the old stack
SPSAV		EQU		$-2
$?3		LD		HL,$-$
AFSAV		EQU		$-2
		PUSH		HL			;Restore AF
		POP		AF
		LD		HL,$-$			;Restore HL
HLSAV		EQU		$-2
		EI					
		RET
OPREG_SV_AREA	EQU		$-1
		DB		0,0,0,0,0,0,0,0