		SUBTITLE"<* SYSRES Page 0 - RST's, data, and buffers *> "
		newpage
		scope
		DEFINE	PAGE0,ORG=%0000


zRST00		JP	zspace.OVERLAY$		; Let the party begin.	
		db  	00000100b		; XY...ZZZ X=1=quiet X=0=normal. Y=1 network, y=0 no net. ZZZ default startup mode.
BANKRES		db	0
CPMEMULATOR	ret				;CP/M emulator SVC.
		dw	0
zRST08	  	RET
        	DW	0
SVCRET$ 	DW 	0             		;Return address from SVC
LSVC$	   	DB  	0	    	        ;Last SVC executed
FDDINT$ 	DI      	                ;NOP or DI (F3h) for
        	RET             	        ;System (Smooth)
zRST10	  	RET
        	DW	0

USTOR$ 	 	BLKB    3,0 			;User storage area
		DW	0			;IV.DMPVID
zRST18  	RET	
        	DW	0
PDRV$		DB 	1			; Current drive, physical.
PHIGH$ 	 	DW	0			; Physical HIGH$. This filled in at initialization.
zLOW$   	DW	COREMIN$		; Lowest usable memory
zRST20 	 	RET
        	DW	0
LDRV$ 	  	DB	0			;Current drive, logical
JDCB$   	DW	0			;Saved FCB pointer
JRET$   	DW 	0			;Saved I/O return address
zRST28		jp	RST28			;System SVC processor
TIMSL$ 	 	DB  	55h			;Fast=55, slow=FF
TIMER$  	DB  	0			;RTC heartbeat counter.
TIME$   	db	0,0,0			;SS:MM:HH storage area
zRST30 	 	JP  	zDEBUG			;DEBUG call address
DATE$	   	DB	23
		DB	17
		DB	03
		DB	76			; Day of year.
		DB	3			; YY/DD/MM/packed
			
zRST38  	jp	zRST38			; Interrupt RST

OSRLS$		DB	01h			; <631>OS Release #

;       INTIM$ stores the image read from RDINTSTATUS*

INTIM$  	DB      0	      		;Interrupt latch image

;       INTMSK$ masks the image read from RDINTSTATUS*
;       LDOS 6.x permits only RS-232 RCV INT, IOBUS INT,
;       and RTC INT to be used by the TASKER off of RST38

INTMSK$ 	DB	2Ch	    		;Mask for INTIM$

;       INTVC$ stores the eight vectors associated
;       with the INTIM$ bit assignments


INTVC$ 	   	DW	RETINST,RETINST,RETINST,RETINST       	;Primary interrupts
        	DW	RETINST,TASKER,RETINST,RETINST

; TCB$ stores the TCB vectors for task slots 0-11
;
TCB$    	DW	NOTASK,NOTASK,NOTASK,NOTASK		;Interrupt task table, IM 1.
		DW	NOTASK,NOTASK,NOTASK,NOTASK		;Interrupt task table, IM 1.
		DW	NOTASK,NOTASK,NOTASK,NOTASK		;Interrupt task vectors.

; NMI vector used in disk I/O

zNMI   		RET
		DW	0

; OVRLY$ stores the system"s overlay request #

OVRLY$		DB	0            	;Current overlay resident

;{> FLGTAB$ stores 26 system flags and images (A-Z).
;{> A pointer to this table is obtained from SVC-zFLAGS.

FLGTAB$ 	EQU	$

AFLAG$		DB	1          		; A FLAG - Start CYL for Allocation search
BFLAG$		DB	0            		; B FLAG

;	CFLAG$ assignments.
;        0 - Cannot change HIGH$ via SVC-100
;        1 - zCMNDR in execution
;        2 - zKEYIN request from SYS1
;        3 - System request for drivers, filters, DCTs
;        4 - zCMNDR to only execute LIB commands
;        5 - Sysgen inhibit bit
;        6 - zERROR inhibit display
;        7 - zERROR to use user (DE) buffer

CFLAG$  	DB  	0			; Condition flag

;	DFLAG$ assignments:
;        0 - SPOOL is active
;        1 - TYPE ahead is active
;        2 - VERIFY is on
;        3 - SMOOTH active
;        4 - MemDISK active
;        5 - FORMS active
;        6 - KSM active
;        7 - accept GRAPHICS in screen print

DFLAG$		DB	00001010B		; DEV Flag (SMOOTH,TYPE)

;       EFLAG$ - Assignments: (sys13 usage)
;       use only bits 4, 5 and 6 to indicate user
;       entry code to be passed to SYS13. SYS13
;       will be executed from SYS1 if this byte
;       is NON/0, bit 4, 5 and 6 will be merged into
;       the SYS13 (1000,1111b) overlay request

EFLAG$  	DB	0	        	; Flag E
FEMSK$  	DB	0			; Port FE mask
GFLAG$		DB	0			; G Flag.
HFLAG$		DB	0			; Flag H.

;      IFLAG$ - Assignments: (INTERNATIONAL)
;        0 - FRENCH
;        1 - GERMAN
;        2 - SWISS
;        3 -
;        4 -
;        5 -
;        6 - Special DMP mode ON/OFF
;        7 - '7' bit mode ON/OFF

IFLAG$		DB	0			; Flag I
JFLAG$		DB	0			; Flag J

;       KFLAG$ assignments:
;        0 - BREAK latch
;        1 - PAUSE latch
;        2 - ENTER latch
;        3 - reserved
;        4 - reserved
;        5 - CAPs lock
;        6 - reserved
;        7 - character in TYPE ahead

KFLAG$		DB	0           		; Keyboard flag

;       LFLAG$ assignments:
;        0 - inhibit step rate question in FORMAT
;        4 - inhibit 8" query in FLOPPY/DCT
;        5 - inhibit # sides question in FORMAT
;        6,7 - Reserved for IM 2 hardware
;

LFLAG$		DB	00000001B   		; LDOS feature inhibit

;       MODOUT$ mask assignments:
;        0 -
;        1 - cassette motor on/off
;        2 - mode select (0 = 80/64, 1 = 40/32)
;        3 - enable alternate character set
;        4 - enable external I/O
;        5 - video wait states (0 = disable, 1 = enable)
;        6 - clock speed ( 1 = 4 Mhz, 0 = 2 MHz)
;        7 -
        	
MODOUT$ 	DB	78h            		; MODOUT port image (FAST)

;       NFLAG$ - Network flag$
;        0 - Allow setting of file open bit in DIR
;        1 / 5 - Reserved
;        6 - Set if in Task Processor
;        7 - Reserved

NFLAG$     	DB	1              		; Inhibit open bit in DIR

;	OPREG$ 	- memory management image port
;        0 - SEL0 - Select map overlay bit 0
;        1 - SEL1 - Select map overlay bit 1
;        2 - 80/64 - 1 = 80 x 24
;        3 - Inverse video
;        4 - MBIT0 - memory map bit 0
;        5 - MBIT1 - memory map bit 1
;        6 - FXUPMEM - fix upper memory
;        7 - PAGE - page 1K video RAM (set for 80x24)
;

OPREG$  	DB	87h       	  	; Memory management image

;       PFLAG$ - Printer flag
;       7 = Printer spooler is paused
;       0 - 6 = Reserved

PFLAG$   	DB	0
QFLAG$   	DB	0

;       RFLAG$ - Retry init for FDC driver

RFLAG$  	DB	8       	      	; FDC retry count >=2

; SFLAG$ assignments:
;        0 - inhibit file open bit
;        1 - set to 1 if bit-2 set & EXEC file opened
;        2 - set by zRUN to permit load of EXEC file
;        3 - SYSTEM (FAST)
;        4 - BREAK key disabled
;        5 - JCL active
;        6 - force extended error messages
;        7 - DEBUG to be turned on after load

SFLAG$  	DB	00001000b           	; System flag (FAST)

;       Machine TYPE assignment:
;       All values are in decimal
;
;        2 = TRS-80 Model 2
;        4 = TRS-80 Model 4
;        5 = TRS-80 MODEL 4P
;       12 = TRS-80 Model 12
;       16 = TRS-80 Model 16

TFLAG$		DB	5         	  	; Model 4 assignment
UFLAG$		DB	0			; Flag U

;       Video FLAG$ assignments:
;        0-3 - Set blink rate (1=fastest,7=slowest)
;        4 - display CLOCK
;        5 - cursor blink toggle bit
;        6 - Inhibit blinking cursor (user)
;        7 - Inhibit blinking cursor (system)

VFLAG$  	DB	40h              	; Blink,Slow,No clock

;       WRINT$ - interrupt mask register
;        0 - enable 1500 baud rising edge
;        1 - enable 1500 baud falling edge
;        2 - enable real time clock
;        3 - enable I/O bus interrupts
;        4 - enable RS-232 transmit interrupts
;        5 - enable RS-232 receive data interrupts
;        6 - enable RS-232 error interrupt

WRINT$  	DB     0    	        	; WRINTMASK port image
XFLAG$  	DB     0	       	       	; Flag x

;       Bits 0-7 indicate new style dating on drives 0-7

YFLAG$  	DB      0FFh
ZFLAG$   	DB      0        	   	; Z flag

;       Contents are high-order byte of SVC table

MSBSVC		DB      SVCTAB$>>8   	  	; MSB of SVC table

;       OSVER$ stores the operating system version

OSVER$  	DB      63h   			; OS version #

;       Vector for config initialization

zICNFG  	RET               	     	; Initialization config
        	DW      0

;       Chain vector for KI task processor

zKITSK  	RET               	     	; Keyboard task routine
	      	DW      0

;       System File Control Block for overlays

SFCB$   	DB      80h,0,0   	     	; System /SYS FCB
        	DW      SBUFF$
        	DB      0
	       	DW      0,0,0,-1,0,-1,-1

;       32-byte DEBUG save area

DBGSV$ 		BLKB    32,0

;       Job Control Language File Control Block

JFCB$  		BLKB    3,0
	       	DW      SBUFF$
	      	BLKB    27,0

;       System Command Line file control block

CFCB$   	EQU     $             	 	; Command Interpreter FCB.
CFGFCB$ 	DB      "CONFIG/SYS.CCC:0",ETX.asc
			BLKB    15,0