		SUBTITLE	"< Line Printer Driver. >"
		newpage
		scope

; Update to LSDOS 6.3.1 2022-09-16 dpm
			
		ORG	driver.PR

;	PR driver entry point
;	It passes X"00'-X"FF"


PRDVR		JR	PRBGN		; Branch around linkage
		DW	PREND		; Last byte used
		DB	3,"$PR" 
		DW	PRDCB$	 	; Pointer to its DCB
		DW	0		; Reserved
PR_NET_CMD	db	"#00000",LF.asc ; Network command...0 is filled with byte to print.

;	Driver code

PRBGN		JR	Z,$?2		; Go if output
		JR	C,$?1		; Go if input req

;	Character CTL request

		OR	A		; status else
		JR	Z,$?4		; treat as a Get

;	Character GET request

$?1		OR	0FFh		;Set nz
		CPL			;& A=0 to show
		RET			;no char available

;	Character PUT request

$?2		ld	h,0
		LD	l,C		; If CTL 0, return.
		HEXDEC	hl,PR_NET_CMD+1
		ZEROS_RPL_SPACE	PR_NET_CMD+1 ; Convert leading spaces in buffer to 0's.
		UART1.put.bytes	7,PR_NET_CMD,pr_net_err
		ret

pr_net_err	pop	bc		; Discard return address of error.
		LD	A,8		; Device not avail...
		OR	A		; Set NZ condition
		RET

$?4		IN0    	A,(UART1_LSR)	; Xmit ready?
		and	UART_THRE
		xor	UART_THRE	; 0 if yes.
		RET			; Return with answer