		SCOPE
; Update to LSDOS 6.3.1 2022-09-16 dpm
; Keyboard line input routine.
; Backspace to beginning of line.

$?4		CALL	$?6		;Backspace
		DEC	HL		;Get the char prior.
		LD	A,(HL)		;to the current
		INC	HL
		CP	0Ah		;Return if line feed
		RET	Z		
$?5		LD	A,B		;Check for empty buffer
		CP	C
		JR	NZ,$?4		;Loop if not
		RET			;else return

zKEYIN		PUSH	HL		;Save buffer pointer
		LD	C,B		;Set C = buffer size
$?1		LD	DE,zKEY		; Init for standard input
		LD	A,(SFLAG$)	;If JCL is active,
		AND	20h		;then use the JCL input
		JR	Z,$?0		;Must loop here in case
		LD	E,zJCL&0FFh	;JCL exits with //STOP
$?0		LD	($?1A+1),DE
$?1A		call	$-$		;Get a key.
		JR	NZ,$?3B		;Back on error
		CP	80h		;Break?
		JR	Z,$?10
		CP	20h		;Go if not a control.
		JR	NC,$?2
		CP	CR.asc		;Carriage return?
		JR	Z,$?11
		CP	1Fh		;Clear?
		JR	Z,$?3
		LD	DE,$?1		;Set return address.
		PUSH	DE
		CP	08h		;Backspace?
		JR	Z,$?6	
		CP	18h		;Backspace to BOL?
		JR	Z,$?5
		CP	09h		;Tab?
		JR	Z,$?8
		CP	'R'&1Fh		;CTL-R?
		JR	Z,$?7
		CP	LF.asc		;Line feed?
		RET	NZ		;Ret if none above
		POP	DE		;Pop the return
$?2		LD	(HL),A		;Stuff the char
		LD	A,B		;Check on buffer full
		OR	A
		JR	Z,$?1		;Loop if so
		LD	A,(HL)		;else get char
		INC	HL		;& bump pointer
		DEC	B		;Count down
		CALL	zDSP		;Display entry
		JR	$?3A		;then loop

;		Clear the screen invoked

$?3		CALL	zCLS
		LD	B,C		;Reset to start of
		POP	HL		;line & start of
		PUSH	HL		;buffer
$?3A		JR	Z,$?1
$?3B		JR	$?11

;		Backspace key entry

$?6		LD	A,B		;If buffer is empty,
		CP	C		;return
		RET	Z
		DEC	HL		;else do the backspace
		LD	A,(HL)
		CP	LF.asc		;Last char a linefeed?
		INC	HL
		RET	Z		;Return if so
		DEC	HL
		INC	B		;Add back one char
		LD	A,BS.asc		;Backspace the cursor
		jr	zDSP
; Test if repeat last command

$?7		LD	A,(CFLAG$)	;Test if SYS1 KEYIN bit
		AND	4		;is set (bit 2)
		RET	Z		;Ignore CTL if not
		LD	A,B		;If not at 1st position,
		CP	C		;don"t permit it
		RET	NZ
		POP	HL		;Pop return to KEY
		POP	HL		;Point to command buffer
		JP	zDSPLY		;Display the old command

;	Tab entered

$?8		PUSH	HL		;Get pos on line
		CALL	ADDR_2_ROWCOL 	;Get row,col in HL
		LD	A,L		;Xfer column to A
		POP	HL	
		AND	7
		NEG			;Negate and add tab
		ADD	A,8
		LD	E,A		;Reg E has tab length
$?9		LD	A,B		;Check on buffer full
		OR	A
		RET	Z
		LD	A,' '		;Put spaces until
		LD	(HL),A		;tab expanded
		INC	HL
		CALL	DSPBYT
		RET	NZ
		DEC	B		;Dec buffer remaining
		DEC	E		;Dec tab count
		RET	Z
		JR	$?9

; Exit KEYIN routine

$?10		SCF			;BREAK exit with CF
$?11		PUSH	AF		;Save flag
		LD	A,CR.asc		;Stuff CR at end
		LD	(HL),A
		CALL	zDSP		;& display it
		LD	A,C		;Calculate # of chars
		SUB	B		;entered.
		LD	B,A
		POP	AF		;Rcvr flag
		POP	HL		;Restore buffer ptr
		RET
