		SUBTITLE	"< SVC handler routines. >"
		NEWPAGE
		SCOPE
; Update to LSDOS 6.3.1 2022-09-16 dpm

		ORG	zspace.SVCHANDLER$
							
zFLAGS		LD	IY,FLGTAB$
		RET

zBREAK		PUSH	HL			;Save user vector
		LD	HL,(BRKVEC$)		;P/u current vector
		EX	(SP),HL			;Save current & get user
		LD	(BRKVEC$),HL		;Stuff new vector
		POP	HL			;Recover old vector
		RET

zWHERE		POP	HL
		JP	(HL)

;	Code for these SVCs is in system overlays

zCMNDR		LD	A,0A3h			;Interpret command & RET
		RST	40
zCMNDI		LD	A,0B3h			;Interpret a command
		RST	40
zFSPEC		LD	A,0C3h			;Parse a filespec
		RST	40
zFEXT		LD	A,0D3h			;Optional default EXT
		RST	40
zPARAM		LD	A,0E3h			;Parameter scanner
		RST	40
zOPEN		LD	A,94h			;Open a file
		RST	40
zINIT		LD	A,0A4h			;Initialize a file
		RST	40
zGTDCB		LD	A,0B4h			;Get a DCB vector
		RST	40
zCKDRV		LD	A,0C4h			;Drive available?
		RST	40
zRENAME		LD	A,0F4h			;Rename a file
		RST	40
zCLOSE		LD	A,95h			;Close a file
		RST	40
zFNAME		LD	A,0A5h			;Recover filespec
		RST	40
zDBGHK		RET				;Init DEBUG off (NOP=on)
zDEBUG		PUSH	AF
		LD	A,97h			;Enter system Debugger
		RST	40
EXTDBG$		DW	ORARETz			;Hook for extended DEBUG.
zREMOVE		LD	A,9Ch			;Remove a file/device
		RST	40
zDOKEY		LD	A,0CDh			;DO execution
		RST	40
zRAMDIR		LD	A,09Eh			;Directory data
		RST	40
zDODIR		LD	A,0AEh			;Directory data
		RST	40
zGTMOD		LD	A,0BEh			;Get module address
		RST	40

;	These SVCs handle the disk primitive requests.

zDCSTAT		XOR	A			; FDC status
		JR	IOFUNC
TAPDRV		LD	A,(LDRV$)		; P/u drive #
		LD	C,A
zSLCT		LD	A,1			; Select drive
		JR	IOFUNC
zDCINIT		LD	A,2			; FDC init
		JR	IOFUNC	
zDCRES		LD	A,3			; FDC reset
		JR	IOFUNC
zRSTOR		LD	A,4			; Restore to cyl 0
		JR	IOFUNC
zSTEPI		LD	A,5			; Step in 1 cyl
		JR	IOFUNC
zSEEK		LD	A,6			; Seek a track/sector
		JR	IOFUNC
zRSLCT		LD	A,7			; Re-select drive
		JR	IOFUNC
zRDHDR		LD	A,8
		JR	IOFUNC
zVRSEC		LD	A,10			; Verify a sector
		JR	IOFUNC
zRDTRK		LD	A,11			; Read a track.
		JR	IOFUNC
zHDFMT		LD	A,12			; Format drive.
		JR	IOFUNC
zWRSEC		LD	A,13			; Write standard sector
		JR	IOFUNC
zWRSSC		LD	A,14			; Write a system sector
		JR	IOFUNC
zWRTRK		LD	A,15			; Write a track
		JR	IOFUNC
zRDSEC		LD	A,9			; Read a sector.