
; Use which terminal for your session connection?

whichterminal$	db	CR.asc
		db	LF.asc
		DB	"        S E S S I O N  C O N N E C T I O N",CR.asc
		db	"        __________________________________",CR.asc,LF.asc

		db	'  0. Do not load a terminal session.',CR.asc
		db	'  1. I am connecting with grandpas teletype (TTY).',CR.asc
		db	'  2. Use ADDS Regent 25 standard (ADDS25).',CR.asc
		db	'  3. Use real model 4 or emulator (TERM6).',CR.asc
		db	'  4. VT100 real time screen updating.',CR.asc
		db	'  5. $BIT Binary Instrumentation Telemetry.',CR.asc
		db	CR.asc
		db	" ESC or enter connection method: "
		db	ETX.asc					; Tell pump macro this is end of screen.

set_terminal	GOSUB	scrolloff
		PUMP	DEVICE.console,whichterminal$
getterm		GOSUB	getchar
		cp		ESC.asc		; Did they hit escape?
		IF_EQ_GOTO	main_ipl_menu

term_setup	cp	'0'			; 0 - NO terminal.
		IF_EQ_GOTO	defaultterm
		cp	'1'			; 1 - Dumb TTY configuration?
		IF_EQ_BRANCH	ttyterm
		cp	'2'			; 2 - ADDS 25 configuration?
		IF_EQ_BRANCH	addsterm
		cp	'3'			; 3 - Term6 special model 4 connection.
		IF_EQ_BRANCH	term6v
		cp	'4'			; 4 - Load default SYSGEN.
		IF_EQ_BRANCH	realtim
		cp	'5'			; 5 - Startup in $BIT mode.
		IF_EQ_GOTO	dollar_bit

		BRANCH	getterm
			
defaultterm	MVC	defltterm$,session_cmd$,15
		ld	a,0
		ld	(quiet_default_flg),a
		ret
ttyterm		MVC	dmbtty$,session_cmd$,15		; Move dumtty into SYSGEN file name.
		ld	a,1
		ld	(quiet_default_flg),a
		ret
addsterm	MVC	adds25$,session_cmd$,15		; Move ADDS 25 SYSGEN file name.
		ld	a,2
		ld	(quiet_default_flg),a
		ret
term6v		MVC	term6v$,session_cmd$,15		; Move special TERM6 file name.
		ld	a,3
		ld	(quiet_default_flg),a
		ret
realtim		ld	a,4
		ld	(quiet_default_flg),a
		MVC	realtim$,session_cmd$,15
		xor	a				; A=0 or NOP.
		ld	(pump_switch_value),a		; Enable pump switch, this updates display in real time.
		ret
dollar_bit	
		ld	a,5
		ld	(quiet_default_flg),a
		MVC	bit_boot$,session_cmd$,15		; Move special TERM6 file name.
		ret

adds25$		db	"do HOST25      ",CR.asc
dmbtty$		db	"do HOSTTTY     ",CR.asc
term6v$		db	"do HOST6V      ",CR.asc
bit_boot$	db	".Running $BIT  ",CR.asc
defltterm$	db	"               ",CR.asc
realtim$	db	"cls            ",CR.asc
session_cmd$	db	"               ",CR.asc