; This code loads in system overlay region, @ 1E00h.
; This module comprises SYS0.
; It runs one time @IPL & is destroyed during boot to ready.


; Next step, initialize CPU.
                
		include "ipl-eZ80_CPU.s"
		
; Start TRS-OS.
; Using TRS-OS, user starts TRSDOS using selected options - POST, RTC setup etc.
; Turn control to TRSDOS/LS-DOS.

		org         4300h+80                            ; Protect data from sysgen residing @4300h...

; Initialize BIOS.

		include "ipl-BIOS.s"                            ; Hardware initialization code for stack, banks etc.

;	IPL DOS contains main loop of TRS-OS startup. Main menu & input loop.

; Initialize DOS.

		include "ipl-DOS.s"                             ; DOS initializaton, SYSGEN, interrupts, welcome message module.

		include "ipl-trsdos.s"                          ; Final initialization of TRSDOS/auto command/ready prompt.
		include "ipl-RTC.s"                             ; Real time clock calander setup.
		include "ipl_rtc_screens.s"                     ; Menu & screen data for RTC routines.
		include "ipl_net_ping.s"                        ; Wiggle i/o line and test if server there.
		include "ipl_net_echo.s"                        ; Send 256 byte to server, wait for server to echo packet.
		include "ipl_net_bind.s"                        ; Bind TRSDOS volume x to network driver.
		include "ipl_net_stats.s"		        		; Code to display server status on server.
		include "ipl_net_utils.s"                       ; Menu containing network utilities.
		include "ipl_net_utilities.s"                   ; Menu containing network utilities.
		include "ipl_net_qserv.s"                       ; Query server to learn parameters.
		include "ipl-SLICE.s"                           ; Manage SLICE tables.
		include "ipl-subroutines.s"                     ; General subroutines needed.
		include "main_menu_screen.s"                    ; Get main menu of TRS-OS
		include "lsdos_splash_screen.s"                 ; Original splash screen of LS-DOS 6.3.1
		include "welcome_screen.s"                      ; TRS-OS welcome screen with copyright notice.
		include "initial_message_screen.s"              ; Contains initialization messages.
		include "ipl_error_screen.s"                    ; Error messages possible during IPL.
		include "ipl_sessions.s"                        ; Include menu for session connection selection.
		include "config_menu_screen.s"                  ; Menu to enter CONFIG to load.
		include "ipl-strings.s"                         ; IPL messages, screens, texts.
		include "ipl_buffers.s"                         ; Buffers used during IPL of system.

; At runtime one of two vector tables (f91/f92) is installed in HIGH$ memory.

		include "f91_interrupt_vectors.s"               ; f91 Interrupt vector tables.
		include "f92_interrupt_vectors.s"               ; f92 Interrupt vector tables.


;---------------- Test Code.------------------

test1;  	stat_server_x
test2;  	bind_server_x
test3;  	query_server_x
test4;		echo	echo_on_exit,echo_on_error
echo_on_exit	put.DSP.LINE echo_done$
		ld	a,CR.asc
		RETURN
echo_done$	db	" ECHO command done.",CR.asc
echo_on_error	error.ABORT a							; Report error, there is no return.
test5;		ping	ping_on_exit,ping_on_error
ping_on_error	error.ABORT a							; Report error, there is no return.
ping_on_exit	put.DSP.LINE ping_done$					; Display message line.
		ld	a,CR.asc
		RETURN
ping_done$	db	" PING command done.",CR.asc

;				include	"stat_server.s"
;				include	"bind_server.s"
;				include	"query_server.s"
;				include "macro_ECHO.s"
;				include "macro_PING.s"

;--------------- END of TEST CODE --------------------

